import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { AnalyticsComponent } from './analytics/analytics.component';
import { EcommerceComponent } from './ecommerce/ecommerce.component';
import { SalesComponent } from './sales/sales.component';
import { CryptoComponent } from './crypto/crypto.component';
import { CrmComponent } from './crm/crm.component';
import { HrmComponent } from './hrm/hrm.component';
import { JobsComponent } from './jobs/jobs.component';
import { NftComponent } from './nft/nft.component';
import { PersonalComponent } from './personal/personal.component';
import { ProjectsComponent } from './projects/projects.component';
import { StocksComponent } from './stocks/stocks.component';
import { CourseComponent } from './course/course.component';
import { CompanyRegistrationComponent } from '../company-components/company-registration/company-registration.component';
import { JobDetailManagementComponent } from '../job-detail-components/job-detail-management/job-detail-management.component';
import { JobDescriptionComponent } from '../company-components/job-description/job-description.component';
import { AccountSettingsComponent } from '../company-components/account-settings/account-settings.component';
import { NameRegistrationComponent } from '../competency-assessment/name-registration/name-registration.component';
import { ToolRegisterComponent } from '../competency-assessment/tool-register/tool-register.component';
import { CourseRegistrationComponent } from '../competency-assessment/course-registration/course-registration.component';
import { CompetencyManagementComponent } from '../competency-assessment/competency-management/competency-management.component';
import { EditGroupCompetenciesComponent } from '../competency-assessment/competency-management/group-competencies/edit-group-competencies/edit-group-competencies.component';
import { EvaluationCycleManagerComponent } from '../competency-assessment/evaluation-cycle-manager/evaluation-cycle-manager.component';
import { SettingCompetencyComponent } from '../competency-assessment/setting-competency/setting-competency.component';
import { IdpDevelopmentPlanComponent } from '../competency-assessment/idp-development-plan/idp-development-plan.component';
import { JobCompetencyComponent } from '../job-detail-components/job-competency/job-competency.component';
import { JobQualificationsComponent } from '../job-detail-components/job-qualifications/job-qualifications.component';
import { JobDetailComponent } from '../job-detail-components/job-detail/job-detail.component';
import { CommandStructureComponent } from '../job-detail-components/command-structure/command-structure.component';
import { AssessmentManagementComponent } from '../performance-management-evaluation/assessment-management/assessment-management.component';
import { JobPositionIndicatorsComponent } from '../job-detail-components/job-position-indicators/job-position-indicators.component';
import { EvaluationCyclePerformanceComponent } from '../performance-management-evaluation/evaluation-cycle-performance/evaluation-cycle-performance.component';
import { SupervisorEvaluationComponent } from '../performance-evaluation/supervisor-evaluation/supervisor-evaluation.component';
import { EmployeeRegistrationComponent } from '../company-components/employee-registration/employee-registration.component';
import { NameRegistrationPerfomanceComponent } from '../performance-management-evaluation/name-registration-perfomance/name-registration-perfomance.component';
import { EvaluationFactorsComponent } from '../performance-management-evaluation/evaluation-factors/evaluation-factors.component';
import { GradeRegistrationComponent } from '../competency-assessment/grade-registration/grade-registration.component';
import { SettingPerformanceEvalutionComponent } from '../performance-management-evaluation/setting-performance-evalution/setting-performance-evalution.component';
import { SelfEvaluationComponent } from '../performance-evaluation/self-evaluation/self-evaluation.component';
import { PmsGradeRegistrationComponent } from '../performance-management-evaluation/pms-grade-registration/pms-pms-grade-registration.component';
import { DayTypeRegistryComponent } from '../company-components/day-type-registry/day-type-registry.component';
import { TimeAttendanceComponent } from '../performance-management-evaluation/time-attendance/time-attendance.component';
import { RolePermissionConfigComponent } from '../company-components/account-settings/role-permission-config/role-permission-config.component';
import { PmsFormEmployeeComponent } from '../performance-evaluation/pms-form-employee/pms-form-employee.component';
import { EmployeeSelfServiceComponent } from '../employee-self-service/employee-self-service.component';
import { MySkillXModuleComponent } from '../my-skill-x-module/my-skill-x-module.component';
import { DashboardEvaluationComponent } from './projects/dashboard-evaluation.component';
import { ReportCom1Component } from '../report-component/report-com/report-com-1/report-com-1.component';
import { ReportCom2Component } from '../report-component/report-com/report-com-2/report-com-2.component';
import { ReportCom3Component } from '../report-component/report-com/report-com-3/report-com-3.component';
import { ReportPms1Component } from '../report-component/report-pms/report-pms-1/report-pms-1.component';
import { ReportPms2Component } from '../report-component/report-pms/report-pms-2/report-pms-2.component';
import { ReportPms3Component } from '../report-component/report-pms/report-pms-3/report-pms-3.component';
import { EssProfileComponent } from '../ess-profile/ess-profile.component';
import { ExcelReportComponent } from '../excel-report/excel-report.component';
import { SettingIndividualKpiComponent } from '../setting-individual-kpi/setting-individual-kpi.component';
import { SettingIndividualKpiSupervisorComponent } from '../setting-individual-kpi-supervisor/setting-individual-kpi-supervisor.component';
import { CompetencyEvaluationFactorsComponent } from '../competency-assessment/competency-evaluation-factors/competency-evaluation-factors.component';
import { ReportCompetencySummaryComponent } from '../report-component/report-com/report-competency-summary/report-competency-summary.component';
import { JobDescriptionEmpComponent } from '../job-description-emp/job-description-emp.component';
import { CompetencyMappingComponent } from '../competency-mapping/competency-mapping.component';
import { Widget1Component } from '../widget1/widget1.component';
import { JobFamilyMappingComponent } from '../job-family-mapping/job-family-mapping.component';
import { JobFamilyMatrixComponent } from '../job-family-matrix/job-family-matrix.component';
import { DocumentUploadManagerComponent } from '../company-components/account-settings/document-upload-manager/document-upload-manager.component';
import { DisciplinaryActionComponent } from '../disciplinary-action/disciplinary-action.component';
import { OutstandingPerformanceComponent } from '../outstanding-performance/outstanding-performance.component'; 
import { PostEvaluationTrackingComponent } from '../post-evaluation-tracking/post-evaluation-tracking.component';



const routes: Routes = [
  {
    path: "",
    children: [
      { path: "dashboard/analytics", component: AnalyticsComponent },
      { path: "dashboard/crypto", component: CryptoComponent },
      { path: "dashboard/ecommerce", component: EcommerceComponent },
      { path: "dashboard/sales", component: SalesComponent },
      { path: "dashboard/crm", component: CrmComponent },
      { path: "dashboard/jobs", component: JobsComponent },
      { path: "dashboard/hrm", component: HrmComponent },
      { path: "dashboard/personal", component: PersonalComponent },
      { path: "dashboard/nft", component: NftComponent },
      // { path: "dashboard/projects", component: ProjectsComponent },
      { path: "dashboard/stocks", component: StocksComponent },
      { path: "dashboard/course", component: CourseComponent },
      { path: "dashboard/projects", component: DashboardEvaluationComponent },


      // myComponent
      { path: "ess/profile", component: EssProfileComponent },
      { path: "ess/self-evaluation", title: 'ประเมินตนเอง', redirectTo: 'ess/self-evaluation/info' },
      { path: "ess/self-evaluation/:part", title: 'ประเมินตนเอง', component: SelfEvaluationComponent },
      { path: "admin/day-type-registry", title: 'ทะเบียนประเภทวัน', component: DayTypeRegistryComponent },
      { path: "admin/company-registration", title: 'ทะเบียนบริษัท', component: CompanyRegistrationComponent },
      { path: "admin/job-description", title: 'ข้อมูลลักษณะงาน', component: JobDescriptionComponent },
      { path: "admin/account-settings", title: 'ตั้งค่าผู้ใช้งาน', component: AccountSettingsComponent },
      { path: "admin/name-registration", title: 'คลังข้อมูลสมรรถนะ', component: NameRegistrationComponent },
      { path: "admin/tool-register", title: 'เครื่องมือประเมิน', component: ToolRegisterComponent },
      { path: "admin/competency-management", title: 'การจัดการสมรรถนะ', component: CompetencyManagementComponent },
      { path: "admin/job-detail-management", title: 'ข้อมูลทั่วไป', component: JobDetailManagementComponent },
      { path: "admin/course-registration", title: 'หลักสูตรการพัฒนา', component: CourseRegistrationComponent },
      { path: "admin/edit-group-competencies", title: 'แก้ไขกลุ่มสมรรถนะ', component: EditGroupCompetenciesComponent },
      { path: "admin/evaluation-cycle-manager", title: 'รอบการประเมิน', component: EvaluationCycleManagerComponent },
      { path: "admin/setting-competency", title: 'การตั้งค่า', component: SettingCompetencyComponent },
      { path: "admin/idp-development-plan", title: 'เเผนพัฒนา IDP', component: IdpDevelopmentPlanComponent },
      { path: "admin/job-competency", title: 'ความสามารถในตำแหน่งงาน', component: JobCompetencyComponent },
      { path: "admin/job-qualifications", title: 'คุณสมบัติที่จำเป็น', component: JobQualificationsComponent },
      { path: "admin/job-detail", title: 'รายละเอียดของงาน', component: JobDetailComponent },
      { path: "admin/command-structure", title: 'โครงสร้างสายการบังคับบัญชา', component: CommandStructureComponent },
      { path: "admin/assessment-management", title: 'การจัดการการประเมิน', component: AssessmentManagementComponent },
      { path: "admin/job-position-indicators", title: 'ตัวชี้วัดของตำแหน่งงาน', component: JobPositionIndicatorsComponent },
      { path: "admin/evaluation-cycle-performance", title: 'รอบการประเมิน', component: EvaluationCyclePerformanceComponent },
      { path: "ess/supervisor-evaluation", title: 'ประเมินโดยหัวหน้า', component: SupervisorEvaluationComponent },
      { path: "ess/supervisor-evaluation/:part", title: 'ประเมินโดยหัวหน้า', component: SupervisorEvaluationComponent },
      { path: "ess/pms-evaluation", title: 'ประเมินผล PMS', component: PmsFormEmployeeComponent },
      { path: "admin/employee-registration", title: 'ทะเบียนพนักงาน', component: EmployeeRegistrationComponent },
      { path: "admin/name-registration-perfomance", title: 'คลังข้อมูลการบริหารผลงาน', component: NameRegistrationPerfomanceComponent },
      { path: "admin/competency-evaluation-factors", title: 'ปัจจัยการประเมินสมรรถนะ', component: CompetencyEvaluationFactorsComponent },
      { path: "admin/evaluation-factors", title: 'ปัจจัยการประเมินผล', component: EvaluationFactorsComponent },
      { path: "admin/grade-registration", title: 'เกรด', component: GradeRegistrationComponent },
      { path: "admin/grade-registration-sub", title: 'เกรด', component: PmsGradeRegistrationComponent },
      { path: "admin/setting-performance-evalution", title: 'การตั้งค่า', component: SettingPerformanceEvalutionComponent },

      { path: "admin/time-attendance", title: 'ทะเบียนการประเมินเวลาทำงาน', component: TimeAttendanceComponent },
      { path: "admin/role-permission-config", title: 'กำหนดสิทธิการเข้าใช้งาน', component: RolePermissionConfigComponent },
      { path: "admin/document-upload-manager", title: 'จัดการอัพโหลดเอกสาร', component: DocumentUploadManagerComponent },
      { path: "ess/employee-self-service", title: 'employee-self-service', component: EmployeeSelfServiceComponent },
      { path: "ess/my-skill-x-module", title: 'my-skill-x-module', component: MySkillXModuleComponent },
      { path: "admin/report-competency-summary", title: 'รายงานสรุปผลการประเมินสมรรถนะ', component: ReportCompetencySummaryComponent },
      { path: "admin/report-com-1", title: 'report-com-1', component: ReportCom1Component },
      { path: "admin/report-com-2", title: 'report-com-2', component: ReportCom2Component },
      { path: "admin/report-com-3", title: 'report-com-3', component: ReportCom3Component },
      { path: "admin/report-pms-1", title: 'report-pms-1', component: ReportPms1Component },
      { path: "admin/report-pms-2", title: 'report-pms-2', component: ReportPms2Component },
      { path: "admin/report-pms-3", title: 'report-pms-3', component: ReportPms3Component },
      { path: "admin/excel-export/:id", title: 'รายงาน Excel', component: ExcelReportComponent },
      { path: "admin/widget1", title: 'Widget1', component: Widget1Component },

      { path: "ess/self-setting-individual-kpi", title: 'แก้ไข Individual KPI ตนเอง', component: SettingIndividualKpiComponent },
      { path: "ess/supervisor-setting-individual-kpi", title: 'แก้ไข Individual KPI โดยหัวหน้า', component: SettingIndividualKpiSupervisorComponent },
      // { path: "admin/job-description-emp", title: 'รายละเอียดของงาน', component: JobDescriptionEmpComponent },
      { path: "ess/job-description-emp", title: 'รายละเอียดของงาน', component: JobDescriptionEmpComponent },
      { path: "ess/competency-mapping", title: 'รายละเอียดของงาน', component: CompetencyMappingComponent },
      { path: "ess/job-family-mapping", title: 'รายละเอียดกลุ่มงานตามวิชาชีพ', component: JobFamilyMappingComponent },
      { path: "ess/job-family-matrix", title: 'รายละเอียดกลุ่มงานตามวิชาชีพ', component: JobFamilyMatrixComponent },
      { path: "ess/disciplinary-action", title: 'วินัยและการลงโทษ', component: DisciplinaryActionComponent },
      { path: "ess/outstanding-performance", title: 'ผลงานดีเด่น', component: OutstandingPerformanceComponent },
      { path: "ess/post-evaluation-tracking", title: 'ผลงานดีเด่น', component: PostEvaluationTrackingComponent },
    ]
  }
];
@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule]
})
export class DashboardRoutingModule { }
