import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { GroupApproveModel } from '../model/group-approve.model';
import { AlertModel } from '../model/alert.model';

@Injectable({
  providedIn: 'root'
})
export class GroupApproveService {
  api = "/group-approve"
  urlApi = environment.baseUrl + this.api
  constructor(private http: HttpClient) {
  }
  getByPersonalLevel(plId: string): Observable<GroupApproveModel> {
    return this.http.get<GroupApproveModel>(this.urlApi + "/" + plId);
  }
  getList(): Observable<GroupApproveModel[]> {
    return this.http.get<GroupApproveModel[]>(this.urlApi + "/lists")
  }
  post(body: GroupApproveModel): Observable<AlertModel> {
          return this.http.post<AlertModel>(this.urlApi, body)
      }
  delete(body: GroupApproveModel) : Observable<AlertModel> {
    const options = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
      body: body
    };
    return this.http.delete<AlertModel>(this.urlApi, options)
  }
}