import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { AlertModel } from '../model/alert.model';
import { EventgrpModel } from '../model/eventgrp.model';

@Injectable({
  providedIn: 'root'
})
export class EventgrpService {
  api = "/eventgrp"
  urlApi = environment.baseUrl + this.api
  constructor(private http: HttpClient) {
  }
  getById(eventgrpId: string): Observable<EventgrpModel> {
    return this.http.get<EventgrpModel>(this.urlApi + "/mini/" + eventgrpId)
  }
  getList(): Observable<EventgrpModel[]> {
    return this.http.get<EventgrpModel[]>(this.urlApi + "/mini/lists")
  }
  getOpenList(): Observable<EventgrpModel[]> {
    return this.http.get<EventgrpModel[]>(this.urlApi + "/mini/lists?status=1")
  }
  getCloseList(): Observable<EventgrpModel[]> {
    return this.http.get<EventgrpModel[]>(this.urlApi + "/mini/lists?status=0")
  }
  post(body: EventgrpModel): Observable<AlertModel> {
    return this.http.post<AlertModel>(this.urlApi, body)
  }
  delete(body: EventgrpModel[]): Observable<AlertModel> {
    const options = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
      body: body
    };
    return this.http.delete<AlertModel>(this.urlApi, options)
  }
}