
import { JobcodeModel, MyJobcodeModel } from "./jobcode.model";
import { MyPLModel, PLModel } from "./pl.model";
import { MyStatusCodeModel, StatusCodeModel } from "./status-code.model";
import { MyStatusFromModel, StatusFromModel } from "./status-from.model";

export interface EvaluationCycleModel {
    evaluationRoundId: string
    companyId: string
    tdesc: string
    edesc: string
    apsyear: string
    apsPeriodStart: string
    apsPeriodEnd: string
    statusCode: StatusCodeModel
    statusFrom: StatusFromModel
    personalLevel: PLModel[]
    jd: JobcodeModel[]
    jlId: string
    active: number
}

export class MyEvaluationCycleModel implements EvaluationCycleModel {
    evaluationRoundId: string
    companyId: string
    tdesc: string
    edesc: string
    apsyear: string
    apsPeriodStart: string
    apsPeriodEnd: string
    statusCode: StatusCodeModel
    statusFrom: StatusFromModel
    personalLevel: PLModel[]
    jd: JobcodeModel[]
    jlId: string
    active: number
    constructor(data?: Partial<EvaluationCycleModel>) {
        this.evaluationRoundId = data?.evaluationRoundId || "";
        this.companyId = data?.companyId || "";
        this.tdesc = data?.tdesc || "";
        this.edesc = data?.edesc || "";
        this.apsyear = data?.apsyear || "";
        this.apsPeriodStart = data?.apsPeriodStart || "";
        this.apsPeriodEnd = data?.apsPeriodEnd || "";
        this.jlId = data?.jlId || "";
        this.active = data?.active || 0;
        this.statusCode = new MyStatusCodeModel(data?.statusCode || {})
        this.statusFrom = new MyStatusFromModel(data?.statusFrom || {})
        this.personalLevel = data?.personalLevel?.map(x => new MyPLModel(x)) || []
        this.jd = data?.jd?.map(x => new MyJobcodeModel(x)) || []

    }
}
