import { AgeModel, MyAgeModel } from "./age.model"
import { BanksModel, MyBanksModel } from "./banks.model"
import { BossModel, MyBossModel } from "./boss.model"
import { BranchModel, MyBranchModel } from "./branch.model"
import { Bu1Model, MyBu1Model } from "./bu1.model"
import { Bu2Model, MyBu2Model } from "./bu2.model"
import { Bu3Model, MyBu3Model } from "./bu3.model"
import { Bu4Model, MyBu4Model } from "./bu4.model"
import { Bu5Model, MyBu5Model } from "./bu5.model"
import { Bu6Model, MyBu6Model } from "./bu6.model"
import { Bu7Model, MyBu7Model } from "./bu7.model"
import { CostcenterModel, MyCostcenterModel } from "./costcenter.model"
import { EmpGroupModel, MyEmpGroupModel } from "./emp-group.model"
import { EmpTypeModel, MyEmpTypeModel } from "./employee-type.model"
import { JobCodeModel, MyJobCodeModel } from "./job-code.model"
import { MyNationalModel, NationalModel } from "./national.model"
import { MyNationalityModel, NationalityModel } from "./nationality.model"
import { MyPLModel, PLModel } from "./pl.model"
import { MyPositionModel, PositionModel } from "./position.model"
import { MyPrefixModel, PrefixModel } from "./prefix.model"
import { MyReligionModel, ReligionModel } from "./religion.model"
import { MySalatypeModel, SalatypeModel } from "./salatype.model"
import { MyStatusModel, StatusModel } from "./status.model"
import { MyTime0Model, Time0Model } from "./time0.model"
import { MyWorkareaModel, WorkareaModel } from "./workarea.model"

export interface EmployeeModel {
    employeeId: string
    prefix: PrefixModel
    fname: string
    lname: string
    efname: string
    elname: string
    nickname: string
    enickname: string
    birthDate: string
    status: StatusModel
    age: AgeModel
    swipeCardId: string
    idPeople: string
    idexpdate: string
    passport_no: string
    passport_expire_date: string
    height: string
    weight: string
    blood: string
    rh: string
    eyeColor: string
    hairColor: string
    shirtSize: string
    waistSize: string
    national: NationalModel
    nationality: NationalityModel
    religion: ReligionModel
    sex: string
    email: string
    emailMicrosoft365: string
    emailPersonal: string
    picture: string
    telNo: string
    mobile: string
    position: PositionModel
    jobCode: JobCodeModel
    personalLevel: PLModel
    companyId: string
    idExpireDate: string
    passportNo: string
    passportExpireDate: string
    bossId: string
    boss: BossModel
    bu1: Bu1Model
    bu2: Bu2Model
    bu3: Bu3Model
    bu4: Bu4Model
    bu5: Bu5Model
    bu6: Bu6Model
    bu7: Bu7Model
    empGroup: EmpGroupModel
    firstHireDate: string
    startDate: string
    ageWork: AgeModel
    empType: EmpTypeModel
    time0: Time0Model
    publicHoliday: string
    proDate: string
    proEvery: string
    approveDate: string
    workarea: WorkareaModel
    telExt: string
    costcenter: CostcenterModel
    branch: BranchModel
    zeemeLogOnName: string
    salatype: SalatypeModel
    effSalatype: string
    salary: string
    empEvery: string
    curchgincDate: string
    receiverBankNo: string
    receiverBank: string
    receiverBankBranch: string
    banks: BanksModel[]
    taxTable: string
    compenTaxTable: string
    idTax: string
    calTax: string
    fixTax: string
    calSoc: string
    calPvf: string
    taxMethodAct: string
    ssoFlag: string
    thFullName: string
    engFullName: string
    pl: PLModel
    resignDate: string
}

export class MyEmployeeModel implements EmployeeModel {
    employeeId: string
    prefix: PrefixModel
    fname: string
    lname: string
    efname: string
    elname: string
    nickname: string
    enickname: string
    birthDate: string
    status: StatusModel
    age: AgeModel
    swipeCardId: string
    idPeople: string
    idexpdate: string
    passport_no: string
    passport_expire_date: string
    height: string
    weight: string
    blood: string
    rh: string
    eyeColor: string
    hairColor: string
    shirtSize: string
    waistSize: string
    national: NationalModel
    nationality: NationalityModel
    religion: ReligionModel
    sex: string
    email: string
    emailMicrosoft365: string
    emailPersonal: string
    picture: string
    telNo: string
    mobile: string
    position: PositionModel
    jobCode: JobCodeModel
    personalLevel: PLModel
    companyId: string
    idExpireDate: string
    passportNo: string
    passportExpireDate: string
    bossId: string
    boss: BossModel
    bu1: Bu1Model
    bu2: Bu2Model
    bu3: Bu3Model
    bu4: Bu4Model
    bu5: Bu5Model
    bu6: Bu6Model
    bu7: Bu7Model
    empGroup: EmpGroupModel
    firstHireDate: string
    startDate: string
    ageWork: AgeModel
    empType: EmpTypeModel
    time0: Time0Model
    publicHoliday: string
    proDate: string
    proEvery: string
    approveDate: string
    workarea: WorkareaModel
    telExt: string
    costcenter: CostcenterModel
    branch: BranchModel
    zeemeLogOnName: string
    salatype: SalatypeModel
    effSalatype: string
    salary: string
    empEvery: string
    curchgincDate: string
    receiverBankNo: string
    receiverBank: string
    receiverBankBranch: string
    banks: BanksModel[]
    taxTable: string
    compenTaxTable: string
    idTax: string
    calTax: string
    fixTax: string
    calSoc: string
    calPvf: string
    taxMethodAct: string
    ssoFlag: string
    thFullName: string
    engFullName: string
    pl: PLModel
    resignDate: string
    constructor(data?: Partial<EmployeeModel>) {
        this.employeeId = data?.employeeId || ""
        this.prefix = new MyPrefixModel(data?.prefix || {})
        this.fname = data?.fname || ""
        this.lname = data?.lname || ""
        this.efname = data?.efname || ""
        this.elname = data?.elname || ""
        this.nickname = data?.nickname || ""
        this.enickname = data?.enickname || ""
        this.birthDate = data?.birthDate || ""
        this.status = new MyStatusModel(data?.status || {})
        this.age = new MyAgeModel(data?.age || {})
        this.swipeCardId = data?.swipeCardId || ""
        this.idPeople = data?.idPeople || ""
        this.idexpdate = data?.idexpdate || ""
        this.passport_no = data?.passport_no || ""
        this.passport_expire_date = data?.passport_expire_date || ""
        this.height = data?.height || ""
        this.weight = data?.weight || ""
        this.blood = data?.blood || ""
        this.rh = data?.rh || ""
        this.eyeColor = data?.eyeColor || ""
        this.hairColor = data?.hairColor || ""
        this.shirtSize = data?.shirtSize || ""
        this.waistSize = data?.waistSize || ""
        this.national = new MyNationalModel(data?.national || {})
        this.nationality = new MyNationalityModel(data?.nationality || {})
        this.religion = new MyReligionModel(data?.religion || {})
        this.sex = data?.sex || ""
        this.email = data?.email || ""
        this.emailMicrosoft365 = data?.emailMicrosoft365 || ""
        this.emailPersonal = data?.emailPersonal || ""
        this.picture = data?.picture || ""
        this.telNo = data?.telNo || ""
        this.mobile = data?.mobile || ""
        this.position = new MyPositionModel(data?.position || {})
        this.jobCode = new MyJobCodeModel(data?.jobCode || {})
        this.personalLevel = new MyPLModel(data?.personalLevel || {})
        this.companyId = data?.companyId || ""
        this.idExpireDate = data?.idExpireDate || ""
        this.passportNo = data?.passportNo || ""
        this.passportExpireDate = data?.passportExpireDate || ""
        this.bossId = data?.bossId || ""
        this.boss = new MyBossModel(data?.boss || {})
        this.bu1 = new MyBu1Model(data?.bu1 || {})
        this.bu2 = new MyBu2Model(data?.bu2 || {})
        this.bu3 = new MyBu3Model(data?.bu3 || {})
        this.bu4 = new MyBu4Model(data?.bu4 || {})
        this.bu5 = new MyBu5Model(data?.bu5 || {})
        this.bu6 = new MyBu6Model(data?.bu6 || {})
        this.bu7 = new MyBu7Model(data?.bu7 || {})
        this.empGroup = new MyEmpGroupModel(data?.empGroup || {})
        this.firstHireDate = data?.firstHireDate || ""
        this.startDate = data?.startDate || ""
        this.ageWork = new MyAgeModel(data?.ageWork || {})
        this.empType = new MyEmpTypeModel(data?.empType || {})
        this.time0 = new MyTime0Model(data?.time0 || {})
        this.publicHoliday = data?.publicHoliday || ""
        this.proDate = data?.proDate || ""
        this.proEvery = data?.proEvery || ""
        this.approveDate = data?.approveDate || ""
        this.workarea = new MyWorkareaModel(data?.workarea || {})
        this.telExt = data?.telExt || ""
        this.costcenter = new MyCostcenterModel(data?.costcenter || {})
        this.branch = new MyBranchModel(data?.branch || {})
        this.zeemeLogOnName = data?.zeemeLogOnName || ""
        this.salatype = new MySalatypeModel(data?.salatype || {})
        this.effSalatype = data?.effSalatype || ""
        this.salary = data?.salary || ""
        this.empEvery = data?.empEvery || ""
        this.curchgincDate = data?.curchgincDate || ""
        this.receiverBankNo = data?.receiverBankNo || ""
        this.receiverBank = data?.receiverBank || ""
        this.receiverBankBranch = data?.receiverBankBranch || ""
        this.banks = data?.banks?.map(x => new MyBanksModel(x)) || []
        this.taxTable = data?.taxTable || ""
        this.compenTaxTable = data?.compenTaxTable || ""
        this.idTax = data?.idTax || ""
        this.calTax = data?.calTax || ""
        this.fixTax = data?.fixTax || ""
        this.calSoc = data?.calSoc || ""
        this.calPvf = data?.calPvf || ""
        this.taxMethodAct = data?.taxMethodAct || ""
        this.ssoFlag = data?.ssoFlag || ""
        this.thFullName = data?.thFullName || ""
        this.engFullName = data?.engFullName || ""
        this.pl = new MyPLModel(data?.pl || {})
        this.resignDate = data?.resignDate || ""
    }
}

