import { CompetencyAssessmentModel, MyCompetencyAssessmentModel } from "./competency-assessment.model"
import { CompetencyBehavioralModel, MyCompetencyBehavioralModel } from "./competency-behavioral.model"

export interface CompetencyIndicatorsCourses2ListModel {
    runNo: number
    companyId: string
    assessmentId: string
    behavioralIndicators: string
    competencyAssessment: CompetencyAssessmentModel[]
    competencyBehavioral: CompetencyBehavioralModel
}
export class MyCompetencyIndicatorsCourses2ListModel implements CompetencyIndicatorsCourses2ListModel {
    runNo: number
    companyId: string
    assessmentId: string
    behavioralIndicators: string
    competencyAssessment: CompetencyAssessmentModel[]
    competencyBehavioral: CompetencyBehavioralModel
    constructor(data?: Partial<CompetencyIndicatorsCourses2ListModel>) {
        this.runNo = data?.runNo ?? 0
        this.companyId = data?.companyId || ""
        this.assessmentId = data?.assessmentId || ""
        this.behavioralIndicators = data?.behavioralIndicators || ""
        this.competencyAssessment = data?.competencyAssessment?.map(x => new MyCompetencyAssessmentModel(x)) || []
        this.competencyBehavioral = new MyCompetencyBehavioralModel(data?.competencyBehavioral)
    }
}

