import { Component, EventEmitter, Input, Output } from '@angular/core';
import { DomSanitizer, SafeHtml } from '@angular/platform-browser';
@Component({
  selector: 'app-job-family-mapping',
  templateUrl: './job-family-mapping.component.html',
  styleUrls: ['./job-family-mapping.component.scss']
})
export class JobFamilyMappingComponent {
  items = Array.from({ length: 10 }, (_, i) => `PART ${i + 1}`);
  colors: string[] = [];

  ngOnInit() {
    this.colors = this.generateUniqueColors(this.items.length);
  }

  generateUniqueColors(count: number): string[] {
    const usedColors = new Set<string>();
    const colors: string[] = [];

    while (colors.length < count) {
      const hue = Math.floor(Math.random() * 360);  // 0–360 องศา
      const saturation = 60 + Math.random() * 10;   // 60–70%
      const lightness = 80 + Math.random() * 10;    // 80–90%
      const color = `hsl(${hue}, ${saturation}%, ${lightness}%)`;
      if (!usedColors.has(color)) {
        usedColors.add(color);
        colors.push(color);
      }
    }

    return colors;
  }

}
