import { Component, EventEmitter, Input, Output } from '@angular/core';

@Component({
  selector: 'app-branch-business-unit',
  templateUrl: './branch-business-unit.component.html',
  styleUrls: ['./branch-business-unit.component.scss']
})
export class BranchBusinessUnitComponent {
  @Input() pathTitle = ['menu.Organization', 'menu.Company', 'BusinessUnit', 'Division']
  @Output() sendPathTitle: EventEmitter<string[]> = new EventEmitter<string[]>();

  currentTab = 1
  onSendPathTitle(pathTitle: string) {
    this.sendPathTitle.emit(['menu.Organization', 'menu.Company', 'BusinessUnit', pathTitle])
  }
}

