import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { PositionModel } from '../model/position.model';
import { AlertModel } from '../model/alert.model';

@Injectable({
    providedIn: 'root'
  })
  export class PositionService {
    api = "/position"
    urlApi = environment.baseUrl + this.api
    constructor(private http: HttpClient) {
    }
    getById(positionId:string): Observable<PositionModel> {
      return this.http.get<PositionModel>(this.urlApi  + "/" + positionId)
    }
    getList(): Observable<PositionModel[]> {
      return this.http.get<PositionModel[]>(this.urlApi + "/lists")
    }
    post(body: PositionModel): Observable<AlertModel> {
      return this.http.post<AlertModel>(this.urlApi, body)
    }
    delete(body: PositionModel | PositionModel[]): Observable<AlertModel> {
      const options = {
          headers: new HttpHeaders({
            "Content-Type": "application/json",
          }),
          body: body
        };
      return this.http.delete<AlertModel>(this.urlApi, options)
    }
  }