import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { Bu5Model } from '../model/bu5.model';
import { AlertModel } from '../model/alert.model';
@Injectable({
  providedIn: 'root'
})
export class Bu5Service {
  api = "/bu5"
  urlApi = environment.baseUrl + this.api
  constructor(private http: HttpClient) {
  }
  getList(): Observable<Bu5Model[]> {
    return this.http.get<Bu5Model[]>(this.urlApi + "/lists")
  }
  getListByParent(bu4id: string): Observable<Bu5Model[]> {
    return this.http.get<Bu5Model[]>(environment.baseUrl + "/bu4/parent/" + bu4id)
  }
  getById(bu5id: string): Observable<Bu5Model> {
    return this.http.get<Bu5Model>(this.urlApi + "/" + bu5id)
  }
  post(body: Bu5Model): Observable<AlertModel> {
    return this.http.post<AlertModel>(this.urlApi, body)
  }
  delete(body: Bu5Model[]): Observable<AlertModel> {
    const options = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
      body: body
    };
    return this.http.delete<AlertModel>(this.urlApi, options)
  }
}
