import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { AssessmentModel } from '../model/assessment.model';
import { AlertModel } from '../model/alert.model';
@Injectable({
  providedIn: 'root'
})
export class AssessmentService {
  api = "/assessment"
  urlApi = environment.baseUrl + this.api
  constructor(private http: HttpClient) {
  }
  getById(competencyTypeId: string): Observable<AssessmentModel> {
    return this.http.get<AssessmentModel>(this.urlApi + "/" + competencyTypeId)
  }
  getList(): Observable<AssessmentModel[]> {
    return this.http.get<AssessmentModel[]>(this.urlApi + "/lists")
  }
  post(body: AssessmentModel): Observable<AlertModel> {
    return this.http.post<AlertModel>(this.urlApi, body)
  }
  delete(body: AssessmentModel | AssessmentModel[]): Observable<AlertModel> {
    const options = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
      body: body
    };
    return this.http.delete<AlertModel>(this.urlApi, options)
  }
}