import { JobcodeModel, MyJobcodeModel } from "./jobcode.model"
import { MyPLModel, PLModel } from "./pl.model"
import { MyPmsGroupAssessment1Model, PmsGroupAssessment1Model } from "./pms-group-assessment1.model"

export interface PmsGroupAssessmentModel {
    personalLevel: PLModel
    jd: JobcodeModel
    jlId: string
    companyId: string
    pmsGroupAssessment1List: PmsGroupAssessment1Model[]
}


export class MyPmsGroupAssessmentModel implements PmsGroupAssessmentModel {
    personalLevel: PLModel
    jd: JobcodeModel
    jlId: string
    companyId: string
    pmsGroupAssessment1List: PmsGroupAssessment1Model[]
    constructor(data?: Partial<PmsGroupAssessmentModel>) {
        this.personalLevel = new MyPLModel(data?.personalLevel)
        this.jd = new MyJobcodeModel(data?.jd)
        this.companyId = data?.companyId || ""
        this.jlId = data?.jlId || ""
        this.pmsGroupAssessment1List = data?.pmsGroupAssessment1List?.map(x => new MyPmsGroupAssessment1Model(x)) || []
    }
}

