export interface CompetencyCourseModel {
    competencyCourseId: string
    companyId: string
    edesc: string
    tdesc: string
    courseDetail: string
    courseTopic: string
    courseLinkMylearn: string
    proceDure: string
    propertyUser: string
    lecTurers: string
    timeLine: string
    expenses: number
}
export class MyCompetencyCourseModel implements CompetencyCourseModel {
    competencyCourseId: string
    companyId: string
    edesc: string
    tdesc: string
    courseDetail: string
    courseTopic: string
    courseLinkMylearn: string
    proceDure: string
    propertyUser: string
    lecTurers: string
    timeLine: string
    expenses: number
    constructor(data?: Partial<CompetencyCourseModel>) {
        this.competencyCourseId = data?.competencyCourseId || ""
        this.tdesc = data?.tdesc || ""
        this.edesc = data?.edesc || ""
        this.companyId = data?.companyId || ""
        this.courseDetail = data?.courseDetail || ""
        this.courseTopic = data?.courseTopic || ""
        this.courseLinkMylearn = data?.courseLinkMylearn || ""
        this.proceDure = data?.proceDure || ""
        this.propertyUser = data?.propertyUser || ""
        this.lecTurers = data?.lecTurers || ""
        this.timeLine = data?.timeLine || ""
        this.expenses = this.toNumber(data?.expenses + '')
    }

    toNumber(value: string): number {
        if (!value) return 0
        const cleaned = value.replace(/[^\d.-]/g, '')
        const num = parseFloat(cleaned)
        return isNaN(num) ? 0 : num
    }
}

