import { ChangeDetectorRef, Component, Input } from '@angular/core';
import { Router, ActivatedRoute } from '@angular/router';
import { AppraisalSubordinateModel, Masfromevaluationassessment } from 'src/app/shared/model/appraisal-subordinate.model';
import { EmployeeModel, MyEmployeeModel } from 'src/app/shared/model/employee.model';
import { AppraisalService } from 'src/app/shared/services/appraisal.service';
import { EmployeeService } from 'src/app/shared/services/employee.service';
import { FileService } from 'src/app/shared/services/file.service';
import { TokenService } from 'src/app/shared/services/token.service';
interface Row { label: string; value: number | string; }
@Component({
  selector: 'app-setting-individual-kpi-supervisor',
  templateUrl: './setting-individual-kpi-supervisor.component.html',
  styleUrls: ['./setting-individual-kpi-supervisor.component.scss']
})
export class SettingIndividualKpiSupervisorComponent {
  subordinate: { loading: false, select?: AppraisalSubordinateModel, dataList: AppraisalSubordinateModel[] } = { loading: false, select: undefined, dataList: [] }
  selectEmp: Map<string, boolean> = new Map<string, boolean>()
  currentPage = 1
  page = Array.from({ length: 1 }, (_, i) => i + 1)
  search = ""
  settingIndividualKpi = false
  constructor(private appraisalService: AppraisalService,
    private fileService: FileService,
    private cdr: ChangeDetectorRef) {
  }
  ngOnInit(): void {
    this.getBossList()
  }
  getBossList() {
    this.appraisalService.getBossList().subscribe({
      next: response => {
        this.subordinate.dataList = JSON.parse(JSON.stringify(response))
        this.cdr.detectChanges()
        if (this.subordinate.dataList.length) {
          this.subordinate.select = JSON.parse(JSON.stringify(this.subordinate.dataList[0]))
          this.cdr.detectChanges()
        }
        this.searchChange()
      }, error: error => {
        this.cdr.detectChanges()
      }
    })
  }
  searchChange() {
    this.currentPage = 1
    this.page = Array.from({ length: Math.ceil(this.subordinateFilter().length / 10) }, (_, i) => i + 1);
  }
  toggleSelectAll() {
    if (this.subordinateFilter().filter(e => e.apsapproveType.code != 'Apsapprove1' && (e.masfromStatusType.code == 'evaluating' || e.masfromStatusType.code == 'pending')).length > 0) {
      if (!this.selectEmp.get('selectAll')) {
        this.selectEmp.set('selectAll', true)
        this.subordinateFilter().filter(e => e.apsapproveType.code != 'Apsapprove1' && (e.masfromStatusType.code == 'evaluating' || e.masfromStatusType.code == 'pending')).forEach(e => {
          this.selectEmp.set(e.apsassessy.employeeId, true)
        })
      } else {
        this.selectEmp.set('selectAll', false)
        this.selectEmp.clear()
      }
    }
  }

  subordinateFilter() {
    if (this.subordinate.select) {
      return this.subordinate.select.masfromevaluationassessment.filter(x => {
        return x.apsassessy.employeeId.toLowerCase().includes(this.search.toLowerCase()) ||
          x.apsassessy.thFullName.toLowerCase().includes(this.search.toLowerCase()) ||
          x.apsassessy.position.tdesc.toLowerCase().includes(this.search.toLowerCase()) ||
          this.statusCompetencyText(x.apsassessy.position.tdesc).toLowerCase().includes(this.search.toLowerCase()) ||
          x.grade.toLowerCase().includes(this.search.toLowerCase()) ||
          x.apsapproveType.tdesc.toLowerCase().includes(this.search.toLowerCase())
      })
    }
    return []
  }
  statusCompetencyText = (status: string) => {
    if (status === "no access") {
      return "ยังไม่ถึงขั้นตอนดำเนินการ"
    } else if (status === "pending") {
      return "รอดำเนินการ"
    } else if (status === "evaluating") {
      return "อยู่ระหว่างดำเนินการ"
    } else if (status === "completed") {
      return "ดำเนินการเสร็จสิ้น"
    } else if (status === "rejected") {
      return "ส่งกลับ"
    } else {
      return ""
    }
  }
  statusButtonClass = (status: string) => {
    if (status === "no access") {
      return "ti-btn-soft-mute"
    } else if (status === "pending") {
      return "ti-btn-soft-secondary"
    } else if (status === "evaluating") {
      return "ti-btn-soft-warning"
    } else if (status === "completed") {
      return "ti-btn-soft-success"
    } else if (status === "rejected") {
      return "ti-btn-soft-danger"
    } else {
      return ""
    }
  }

  getImg(text: string) {
    return this.fileService.getImg(text)
  }

  onImageError(event: Event) {
    const imgElement = event.target as HTMLImageElement;
    imgElement.src = './assets/img/users/defaultperson.jpg';
  }

  checkSelectAll() {
    this.selectEmp.set('selectAll', (this.subordinateFilter().filter(e => e.apsapproveType.code != 'Apsapprove1' && (e.masfromStatusType.code == 'evaluating' || e.masfromStatusType.code == 'pending')).length > 0 && this.subordinateFilter().filter(e => e.apsapproveType.code != 'Apsapprove1' && (e.masfromStatusType.code == 'evaluating' || e.masfromStatusType.code == 'pending')).length == this.selectEmp.size - 1))
  }

  selectSubordinate(data: Masfromevaluationassessment, competencyTypeId: string, evaluationRoundId?: string, masfromStatusType?: string) {
    if (data && evaluationRoundId) {
      // this.formEvaluation.evaluateeId = data.apsassessy.employeeId
      // this.formEvaluation.competencyTypeId = competencyTypeId
      // this.formEvaluation.evaluationRoundId = evaluationRoundId
      // this.formEvaluation.masfromStatusType = masfromStatusType || ''
      // this.formEvaluation.allCompetencyTypeId = data.typeList
      this.cdr.detectChanges()
    }
  }

}
