import { ChangeDetectorRef, Component } from '@angular/core';
import { TranslateService } from '@ngx-translate/core';
import { PivotView } from '@syncfusion/ej2-angular-pivotview';
import { ColumnModel } from '@syncfusion/ej2-grids';
import { CompetencySummaryService } from 'src/app/shared/services/competency-summary.service';
@Component({
  selector: 'app-report-competency-summary',
  templateUrl: './report-competency-summary.component.html',
  styleUrls: ['./report-competency-summary.component.scss']
})
export class ReportCompetencySummaryComponent {
  columns: ColumnModel[] = [{
    field: "no",
    headerText: "ลำดับ",
    type: "string",
    isPrimaryKey: true,
  },
  {
    field: "evaluatee",
    headerText: "ผู้ถูกประเมิน",
    type: "string"
  },
  {
    field: "jobLevel",
    headerText: "ระดับพนักงาน",
    type: "string"
  },
  {
    field: "assessmentPeriod",
    headerText: "รอบการประเมิน",
    type: "string"
  },
  {
    field: "competencyTypes",
    headerText: "ประเภทสมรรถนะ",
    type: "string"
  },
  {
    field: "score",
    headerText: "คะแนน",
    type: "string"
  }]
  searchSettings = {
    fields: ['no', 'evaluatee', 'jobLevel', 'assessmentPeriod', 'competencyTypes', 'score'],
    operator: 'contains',
    ignoreCase: false
  };
  search = ''
  syncfutionDataList: any[] = []
  dataList: { loading: boolean, list: any[] } = { loading: false, list: [] }
  dataSourceSettings: any

  locale = 'th-TH'
  constructor(
    private cdr: ChangeDetectorRef,
    private translateService: TranslateService,
    private competencySummaryService: CompetencySummaryService
  ) {
    this.translateService.onLangChange.subscribe((event) => {
      this.locale = this.translateService.getCurrentLang() == 'th' ? 'th-TH' : 'en-US'
      this.setSyncfutionDataList()
      // this.setPivot()
    });

  }

  setPivot() {
    this.dataSourceSettings = {
      enableSorting: true,
      columns: [],
      rows: [
        { name: 'headpc', caption: 'PC' },
        { name: 'subpc', caption: 'Sub PC' }
      ],
      values: [
        { name: '7', caption: '7 คะแนน' },
        { name: '6', caption: '6 คะแนน' },
        { name: '5', caption: '5 คะแนน' },
        { name: '4', caption: '4 คะแนน' },
        { name: '3', caption: '3 คะแนน' },
        { name: '2', caption: '2 คะแนน' },
        { name: '1', caption: '1 คะแนน' }
      ],

      dataSource: getPivotData(),
      formatSettings: [],
      expandAll: false,
      filters: [],
      // showGrandTotals: false,
      // showRowGrandTotals: false,
      // showColumnGrandTotals: false

    }
    function getPivotData() {
      let pivotData: any[] = [
        { '1': 1, '2': 2, '3': 3, '4': 10, '5': 5, '6': 2, '7': 7, 'headpc': 'pc1', 'subpc': 'pc11', },
        { '1': 5, '2': 4, '3': 5, '4': 20, '5': 10, '6': 3, '7': 8, 'headpc': 'pc1', 'subpc': 'pc12', },
        { '1': 7, '2': 6, '3': 7, '4': 15, '5': 12, '6': 6, '7': 9, 'headpc': 'pc1', 'subpc': 'pc13', },
        { '1': 2, '2': 25, '3': 25, '4': 8, '5': 9, '6': 4, '7': 6, 'headpc': 'pc1', 'subpc': 'pc14', },
        { '1': 5, '2': 83, '3': 83, '4': 11, '5': 7, '6': 5, '7': 10, 'headpc': 'pc1', 'subpc': 'pc15', },
        { '1': 12, '2': 57, '3': 57, '4': 14, '5': 8, '6': 7, '7': 13, 'headpc': 'pc1', 'subpc': 'pc16', },
        { '1': 20, '2': 20, '3': 20, '4': 9, '5': 4, '6': 6, '7': 5, 'headpc': 'pc2', 'subpc': 'pc21', },
        { '1': 0, '2': 93, '3': 93, '4': 12, '5': 6, '6': 3, '7': 7, 'headpc': 'pc2', 'subpc': 'pc22', },
        { '1': 0, '2': 89, '3': 89, '4': 18, '5': 11, '6': 4, '7': 6, 'headpc': 'pc2', 'subpc': 'pc23', },
        { '1': 0, '2': 91, '3': 91, '4': 13, '5': 7, '6': 8, '7': 9, 'headpc': 'pc2', 'subpc': 'pc24', },

      ];

      return pivotData;
    }
  }


  ngOnInit(): void {
    // this.setPivot()
    this.getDataList()
  }

  getDataList() {
    this.dataList.loading = true
    this.competencySummaryService.getCompentencySummaryList().subscribe({
      next: response => {
        this.dataList.list = response
        this.setSyncfutionDataList()
        this.dataList.list = response
        this.dataList.loading = false
        this.cdr.detectChanges()
      }, error: error => {
        this.dataList.loading = false
        this.cdr.detectChanges()
      }
    })

  }
  setSyncfutionDataList() {
    if (this.dataList.list) {
      this.syncfutionDataList = this.dataList.list.map(e => e.masform.map((e2: any) => ({
        no: e2.no,
        evaluatee: e2.apsassessy?.thFullName,
        jobLevel: e2.jl?.tdesc,
        assessmentPeriod: e.tdesc,
        competencyTypes: e2.competencyTypeShortName,
        score: e2.averageScoreBoss,
      }))).flat()
    }
  }
}