import { Component, EventEmitter, Input, Output } from '@angular/core';
import { Competency, Pms } from 'src/app/shared/model/competency.model';

@Component({
  selector: 'app-pms-information',
  templateUrl: './pms-information.component.html',
  styleUrls: ['./pms-information.component.scss']
})
export class PmsInformationComponent {
  @Input() canSave = false
  @Input() complete = false
  @Input() statusType = ''
  @Input() inforWeightBoss: Map<string, string> = new Map<string, string>()
  @Input() inforGapBoss: Map<string, string> = new Map<string, string>()
  @Input() inforWeight: Map<string, string> = new Map<string, string>()
  @Input() inforGap: Map<string, string> = new Map<string, string>()
  @Input() appraisalCompentencyList: Competency[] = []
  @Input() appraisalPms?: Pms
  @Input() kpiScoreBoss: string = ""
  @Input() kpiScore: string = ""
  @Input() kpiGrade: string = ""
  @Input() kpiName: string = ""
  @Input() evaluateeId = ""
  @Input() evaluaterId = ""
  @Input() currentStep = ""
  @Output() sendCurrentTap: EventEmitter<any> = new EventEmitter<any>();
  @Output() sendCurrentPart: EventEmitter<any> = new EventEmitter<any>();
  tableHover: Map<string, boolean> = new Map<string, boolean>()
  menuClose: Map<string, boolean> = new Map<string, boolean>()
  statusButtonClass = (status: string) => {
    if (status === "no access") {
      return "ti-btn-soft-mute"
    } else if (status === "pending") {
      return "ti-btn-soft-secondary"
    } else if (status === "evaluating") {
      return "ti-btn-soft-warning"
    } else if (status === "completed") {
      return "ti-btn-soft-success"
    } else if (status === "rejected") {
      return "ti-btn-soft-danger"
    } else {
      return ""
    }
  }
  formatThaiDate(dateStr?: string): string {
    if (!dateStr) return ''
    const months = [
      '', 'มกราคม', 'กุมภาพันธ์', 'มีนาคม', 'เมษายน', 'พฤษภาคม', 'มิถุนายน',
      'กรกฎาคม', 'สิงหาคม', 'กันยายน', 'ตุลาคม', 'พฤศจิกายน', 'ธันวาคม'
    ];

    const [year, month, day] = dateStr.split('-').map(Number);
    const thaiYear = year + 543;
    const thaiMonth = months[month];

    return `${day} ${thaiMonth} ${thaiYear}`;
  }
}
