import {
  ChangeDetectorRef,
  Component,
  EventEmitter,
  Input,
  Output,
} from '@angular/core';
import { ToastrService } from 'ngx-toastr';
import { SwalService } from 'src/app/components/advanced/sweetalert/sweetalert.component';
import { MyStatusCodeModel, StatusCodeModel } from 'src/app/shared/model/status-code.model';
import { EvaluationCycleService } from 'src/app/shared/services/evaluation-cycle.service';
import Swal from 'sweetalert2';

export interface DataModel {
    evaluationRoundId: string;
    tdesc: string;
    edesc: string;
    apsyear: string;
    apsPeriodStart: string;
    apsPeriodEnd: string;
    statusCode: StatusCodeModel;
}
@Component({
  selector: 'app-define-document-form',
  templateUrl: './define-document-form.component.html',
  styleUrls: ['./define-document-form.component.scss'],
})
export class DefineDocumentFormComponent {
  @Output() sendGroupShow: EventEmitter<string> = new EventEmitter<string>();
  // @Output() evaluationRound: EventEmitter<DataModel> = new EventEmitter<DataModel>();

  currentPage = 1;
  page = Array.from({ length: 1 }, (_, i) => i + 1);
  search = '';
  numDataListChecked = 0;
  isDataListChecked = false;
  isDataListCheckedAll = false;
  modalStatus: 'add' | 'edit' = 'add';
  evaluation_cyclelist:DataModel[] = []
  evaluationRound?:DataModel
  showFrom = false
  constructor(
    private cdr: ChangeDetectorRef,
    private swalService: SwalService,
    private evaluationCycleService: EvaluationCycleService,
    private toastr: ToastrService
  ) {}

  onEdit(evaluationRound:DataModel) {
    this.evaluationRound = evaluationRound;
    this.showFrom = true
  }
  ngOnInit(): void {
    this.getEvaluationCycleList();
  }
  getEvaluationCycleList() {
    this.evaluationCycleService.getList().subscribe({
      next: response => {
        this.evaluation_cyclelist = response.filter(x => x.statusCode&&x.statusCode.code != '2').map(x => ({
            evaluationRoundId: x.evaluationRoundId,
            tdesc: x.tdesc,
            edesc: x.edesc,
            apsyear: x.apsyear,
            apsPeriodStart: x.apsPeriodStart,
            apsPeriodEnd: x.apsPeriodEnd,
            statusCode: new MyStatusCodeModel(x.statusCode || {})
        }));
        this.searchChange();
        this.cdr.detectChanges();
      },
      error: err => {
        console.error('Error fetching evaluation cycles:', err);
      }
    });
  }
  searchChange() {
    this.currentPage = 1
    this.page = Array.from({ length: Math.ceil(this.evaluation_cycleListFilter().length / 10) }, (_, i) => i + 1);
  }
  evaluation_cycleListFilter() {
    return this.evaluation_cyclelist.filter(x =>
      x.tdesc.toLowerCase().includes(this.search.toLowerCase()) ||
      x.edesc.toLowerCase().includes(this.search.toLowerCase()) ||
      x.evaluationRoundId.toLowerCase().includes(this.search.toLowerCase())
    )
  }


  showSuccessDelete() {
    this.toastr.success('ลบข้อมูลสำเร็จ', 'เเจ้งเตือน', {
      timeOut: 3000,
      positionClass: 'toast-top-right',
    });
  }
  basicAlert3() {
    Swal.fire({
      iconHtml: `
      <div class="flex items-center justify-center rounded-full !h-80px !w-80px" style="background-color: #E8F8EE;">
          <svg width="39" height="39" viewBox="0 0 39 39" fill="none" xmlns="http://www.w3.org/2000/svg">
              <rect width="39" height="39" fill="#D2D2D2"/>
              <g id="Component">
                  <g id="alert cart">
                      <g id="mdi:file-export">
                          <circle cx="22.5" cy="19.5" r="33.5" fill="#E8F8EE"/>
                          <path d="M9.75 3.25C8.88805 3.25 8.0614 3.59241 7.4519 4.2019C6.84241 4.8114 6.5 5.63805 6.5 6.5V32.5C6.5 33.362 6.84241 34.1886 7.4519 34.7981C8.0614 35.4076 8.88805 35.75 9.75 35.75H29.25C30.112 35.75 30.9386 35.4076 31.5481 34.7981C32.1576 34.1886 32.5 33.362 32.5 32.5V13L22.75 3.25M21.125 5.6875L30.0625 14.625H21.125M14.5113 19.8575H26V31.3463L22.555 27.9013L17.9563 32.5L13.3575 27.9013L17.9563 23.3188" 
                          fill="#1DBE5A"/>
                      </g>
                  </g>
              </g>
          </svg>
      </div>
      `,
      title: 'ส่งออกเอกสาร',
      text: 'คุณต้องการส่งออกเอกสารฉบับนี้ใช่หรือไม่',
      showCancelButton: true,
      reverseButtons: true,
      confirmButtonText: 'ส่งออกเอกสาร',
      cancelButtonText: 'ย้อนกลับ',
      customClass: {
        title: '!swal2-title-mt-20px',
        actions: '!swal2-actions-mt-20px',
        icon: '!swal2-icon-no-border',
        confirmButton: '!swal2-button-bg-green',
        cancelButton: '!swal2-button-bg-gray',
      },
    }).then((result) => {
      if (result.isConfirmed) {
        Swal.fire({
          title: 'ส่งออกสำเร็จ!',
          text: 'เอกสารของคุณถูกส่งออกแล้ว',
          icon: 'success',
          confirmButtonColor: '#0162e8',
        });
      } else if (result.dismiss === Swal.DismissReason.cancel) {
        Swal.fire({
          title: 'ยกเลิก!',
          text: 'การส่งออกถูกยกเลิก',
          icon: 'error',
          confirmButtonColor: '#f43f5e',
        });
      }
    });
  }
}
